/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.GenericMapper;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.alias.AliasDAOHibernate;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDAOHibernate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AliasMapper
extends GenericMapper
implements Mapper {
    private AliasDAOHibernate aliasDAO;
    private ApplicationDAOHibernate applicationDAO;
    protected static final String ALIAS_XML_ROOT = "aliases";
    protected static final String ALIAS_XML_NODE = "alias";
    protected static final String ALIAS_APPLICATION_ID = "applicationId";
    protected static final String ALIAS_USERNAME = "username";
    protected static final String ALIAS_ALIASNAME = "aliasname";

    public Element exportXml(Map options) throws ExportException {
        Element aliasRoot = DocumentHelper.createElement((String)ALIAS_XML_ROOT);
        List aliases = this.aliasDAO.findAll();
        for (Alias alias : aliases) {
            this.addAliasToXml(alias, aliasRoot);
        }
        return aliasRoot;
    }

    protected void addAliasToXml(Alias alias, Element aliasRoot) {
        Element aliasElement = aliasRoot.addElement(ALIAS_XML_NODE);
        aliasElement.addElement("id").addText(alias.getId().toString());
        aliasElement.addElement(ALIAS_APPLICATION_ID).addText(alias.getApplication().getId().toString());
        aliasElement.addElement(ALIAS_USERNAME).addText(alias.getName());
        aliasElement.addElement(ALIAS_ALIASNAME).addText(alias.getAlias());
    }

    public void importXml(Element root) throws ImportException {
        Element aliasRoot = (Element)root.selectSingleNode("/crowd/ aliases");
        if (aliasRoot == null) {
            this.logger.error((Object)"No aliases were found for importing!");
            return;
        }
        Iterator aliases = aliasRoot.elementIterator();
        while (aliases.hasNext()) {
            Element aliasElement = (Element)aliases.next();
            Alias alias = this.getAliasFromXml(aliasElement);
            this.addEntity(alias);
        }
    }

    protected Alias getAliasFromXml(Element aliasElement) {
        Long id = new Long(aliasElement.element("id").getText());
        Long applicationId = new Long(aliasElement.element(ALIAS_APPLICATION_ID).getText());
        String username = aliasElement.elementText(ALIAS_USERNAME);
        String alias = aliasElement.elementText(ALIAS_ALIASNAME);
        Application application = (Application)this.applicationDAO.loadReference(applicationId.longValue());
        return new Alias(id, application, username, alias);
    }

    public void setAliasDAO(AliasDAOHibernate aliasDAO) {
        this.aliasDAO = aliasDAO;
    }

    public void setApplicationDAO(ApplicationDAOHibernate applicationDAO) {
        this.applicationDAO = applicationDAO;
    }
}

